/*
 * Copyright (C) 2014 Yahoo Inc.
 */

// Url for the default profile image
var DEFAULT_PROFILE_IMAGE = "images/default_profile_image.png";
var PROFILE_IMAGE_BACKGROUND = "images/profile_image_background.png";

// A place holder token representing the profile image data or the image url
var PROFILE_IMAGE_URL_PLACEHOLDER = "#CONTACTSEARCHIMAGE#";

// A circle profile image template
var CIRCLE_PROFILE_IMAGE = "url(), url('" + PROFILE_IMAGE_URL_PLACEHOLDER + "'), url('" + PROFILE_IMAGE_BACKGROUND + "')";
 // A default circle profile image
var DEFAULT_CIRCLE_PROFILE_IMAGE = "url(), url('" + DEFAULT_PROFILE_IMAGE + "'), url('" + PROFILE_IMAGE_BACKGROUND + "')";

/**
 * An object which controls loading and varies states of a profile image
 */
var profileImageController = {
    /**
     * A method which creates and starts an image loader in order to load the given imageUrl into the imageNode.
     * The image is only loaded if it can be successfully retrieved, otherwise a default profile image is shown.
     */
    load: function(imageUrl, imageNode, placeholderImg) {
        if (imageUrl && imageNode) {
            new ImageLoader(imageUrl, imageNode, placeholderImg);
        }
    }
};

/**
 * A class which loads an image into the browser cache and then sets it as a circle in the given imageNode
 */
function ImageLoader(url, imageNode, placeholderImg) {
    this.url = url;
    this.imageNode = imageNode;

    this.imageNode.style.backgroundImage = placeholderImg ? CIRCLE_PROFILE_IMAGE.replace(PROFILE_IMAGE_URL_PLACEHOLDER, placeholderImg) : DEFAULT_CIRCLE_PROFILE_IMAGE;

    // Since we set the profile image as the background of a node,
    // we need to explicitly detect if any of the image links are broken.
    // This is because we cannot add load/error listeners for CSS images.
    // Hence we explicitly try to load an image, and if it works, then set it as the CSS background.
    // Note: We use CSS images, in order to leverage background image composites and masking to show an orbified profile image
    var image = new Image();
    image.addEventListener("load", this.handleImageLoadComplete.bind(this), true);
    image.setAttribute("src", this.url);
}

/**
 * A method which actually sets the circle image on load complete
 */
ImageLoader.prototype.handleImageLoadComplete = function(event) {
    this.imageNode.style.backgroundImage = CIRCLE_PROFILE_IMAGE.replace(PROFILE_IMAGE_URL_PLACEHOLDER, this.url);
};
